/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.logon;

import com.ibm.hwmca.base.logon.Logon;
import com.ibm.hwmca.base.logon.LogonConstants;
import com.ibm.hwmca.base.logon.LogonErrorIds;
import com.ibm.hwmca.fw.connmgr.ConnectionFactory;
import com.ibm.hwmca.fw.connmgr.DisabledUseridException;
import com.ibm.hwmca.fw.connmgr.InvalidPasswordException;
import com.ibm.hwmca.fw.connmgr.PasswordExpiredException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.util.Trace;
import java.net.UnknownHostException;

public class NonPanelLogon
implements LogonConstants,
LogonErrorIds {
    private static final String TRACE_MASKT = "XLGNNONT";
    private static final String TRACE_MASKF = "XLGNNONF";
    private static final String TRACE_MASKD = "XLGNNOND";
    private ConnectionFactory connectionFactory;

    NonPanelLogon() {
        Trace.trace(TRACE_MASKT, "<> NonPanelLogon.NonPanelLogon()");
    }

    void logon(String userid, byte[] password) {
        block11: {
            Trace.trace(TRACE_MASKT, "-> NonPanelLogon.logon()");
            try {
                Logon logon = Logon.getLogon();
                this.connectionFactory = logon.getClientUserContext().getConnectionFactory();
                if (this.resetLogon()) {
                    for (int retryLogonCounter = 0; retryLogonCounter < 3; ++retryLogonCounter) {
                        try {
                            this.connectionFactory.setUserAndPassword(userid, password);
                            logon.setLogonResult(2);
                            break block11;
                        }
                        catch (UnknownHostException exc) {
                            new FrameworkLog(LogonErrorIds.LOGINFO, 98, exc).log();
                            break block11;
                        }
                        catch (ClassNotFoundException exc) {
                            new FrameworkLog(LogonErrorIds.LOGINFO, 98, exc).log();
                            break block11;
                        }
                        catch (InvalidPasswordException exc) {
                            break block11;
                        }
                        catch (DisabledUseridException exc) {
                            break block11;
                        }
                        catch (PasswordExpiredException exc) {
                            break block11;
                        }
                        catch (Exception exc) {
                            Trace.trace(TRACE_MASKF, exc);
                            continue;
                        }
                    }
                    break block11;
                }
                new FrameworkLog(LogonErrorIds.LOGINFO, 98, new Exception("Connection Error")).log();
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, exc);
                new FrameworkLog(LogonErrorIds.LOGINFO, 98, exc).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<- NonPanelLogon.logon()");
    }

    private boolean resetLogon() {
        Trace.trace(TRACE_MASKT, "-> NonPanelLogon.resetLogon()");
        boolean result = false;
        for (int retryResetLogonCounter = 0; retryResetLogonCounter < 3; ++retryResetLogonCounter) {
            try {
                this.connectionFactory.resetUserAndPassword();
                result = true;
                break;
            }
            catch (UnknownHostException exc) {
                Trace.trace(TRACE_MASKF, exc);
                break;
            }
            catch (ClassNotFoundException exc) {
                Trace.trace(TRACE_MASKF, exc);
                break;
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, exc);
                continue;
            }
        }
        Trace.trace(TRACE_MASKT, "<- NonPanelLogon.resetLogon()");
        return result;
    }
}

